uniform sampler2D 	bump;
varying vec2 		texcoord;
varying float		fadeAlpha;

////////////////////////////
vec2 encode(vec3 n)
{
	n=normalize(n);
    float f = sqrt(8.0*n.z+8.0);
    return n.xy / f + 0.5;
}

void main()
{
	vec4 wavesNormal=texture2D(bump,texcoord.st);
	vec3 normal=wavesNormal.xyz*2.0-1.0;
	
	vec3 N=normal;
	N.y=normal.z;
	N.z=-normal.x;
	N.x=-normal.y;
	//N=normalize(N);
	N*=vec3(10.0,10.0,10.0);
	N*=wavesNormal.a*fadeAlpha;
	N=normalize(N);
	N.xy=encode(N);	
	
	// normal
	gl_FragColor.xy=N.xy;
	gl_FragColor.z=wavesNormal.a*fadeAlpha;
	gl_FragColor.a=clamp(wavesNormal.a*fadeAlpha,0.0,1.0);
}
